//Falcon-180B DATASET v1.0 Category: Graph representation ; Style: realistic
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <math.h>

#define MAX_NODES 1000
#define MAX_EDGES 10000

typedef struct node {
    int id;
    double x, y;
    char label[100];
} node_t;

typedef struct edge {
    int from, to;
    double weight;
} edge_t;

node_t nodes[MAX_NODES];
edge_t edges[MAX_EDGES];

int num_nodes = 0;
int num_edges = 0;

void add_node(double x, double y, char* label) {
    if (num_nodes >= MAX_NODES) {
        printf("Error: Maximum number of nodes reached.\n");
        exit(1);
    }
    nodes[num_nodes].id = num_nodes;
    nodes[num_nodes].x = x;
    nodes[num_nodes].y = y;
    strcpy(nodes[num_nodes].label, label);
    num_nodes++;
}

void add_edge(int from, int to, double weight) {
    if (num_edges >= MAX_EDGES) {
        printf("Error: Maximum number of edges reached.\n");
        exit(1);
    }
    edges[num_edges].from = from;
    edges[num_edges].to = to;
    edges[num_edges].weight = weight;
    num_edges++;
}

void print_graph() {
    printf("Graph:\n");
    for (int i = 0; i < num_nodes; i++) {
        printf("Node %d: (%f, %f) %s\n", i, nodes[i].x, nodes[i].y, nodes[i].label);
    }
    for (int i = 0; i < num_edges; i++) {
        printf("Edge %d: from %d to %d with weight %f\n", i, edges[i].from, edges[i].to, edges[i].weight);
    }
}

int main() {
    add_node(0, 0, "A");
    add_node(1, 0, "B");
    add_node(2, 0, "C");
    add_node(3, 0, "D");
    add_node(4, 0, "E");
    add_node(5, 0, "F");
    add_node(6, 0, "G");
    add_node(7, 0, "H");
    add_node(8, 0, "I");
    add_edge(0, 1, 1);
    add_edge(1, 2, 1);
    add_edge(2, 3, 1);
    add_edge(3, 4, 1);
    add_edge(4, 5, 1);
    add_edge(5, 6, 1);
    add_edge(6, 7, 1);
    add_edge(7, 8, 1);
    print_graph();
    return 0;
}