//GPT-4o-mini DATASET v1.0 Category: Simulation of the Solar System ; Style: cheerful
#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>

#define NUM_PLANETS 8

typedef struct {
    char name[20];
    float distance_from_sun; // in millions of kilometers
    float orbit_speed; // in kilometers per hour
} Planet;

void display_planet_info(Planet *planet) {
    printf("%s is %0.2f million km from the Sun and travels at %0.2f km/h.\n", 
           planet->name, planet->distance_from_sun, planet->orbit_speed);
}

void orbit_planets(Planet *planets) {
    for (int i = 0; i < NUM_PLANETS; i++) {
        printf("The planet %s is orbiting the Sun...\n", planets[i].name);
        usleep(500000); // Sleep for half a second
    }
}

int main() {
    Planet solar_system[NUM_PLANETS] = {
        {"Mercury", 57.91, 47.87},
        {"Venus", 108.21, 35.02},
        {"Earth", 149.60, 29.78},
        {"Mars", 227.94, 24.07},
        {"Jupiter", 778.57, 13.07},
        {"Saturn", 1433.53, 9.69},
        {"Uranus", 2872.46, 6.81},
        {"Neptune", 4495.06, 5.43}
    };

    printf("Welcome to the Cheerful Solar System Simulation!\n");
    printf("Let's learn about our lovely planets!\n\n");

    for (int i = 0; i < NUM_PLANETS; i++) {
        display_planet_info(&solar_system[i]);
        printf("\n");
    }

    printf("Now, let's watch our planets happily orbit the Sun!\n\n");
    
    orbit_planets(solar_system);

    printf("\nAll planets have completed one joyful orbit around the Sun!\n");
    printf("Thank you for joining us on this galactic journey!\n");

    return 0;
}