//Gemma-7B DATASET v1.0 Category: Cafe Billing System ; Style: funny
#include <stdio.h>
#include <stdlib.h>

// Define a structure to store customer information
typedef struct customer {
    char name[50];
    char address[100];
    int phone;
} customer;

// Define a structure to store menu items
typedef struct menu_item {
    char name[50];
    int price;
    int quantity;
} menu_item;

// Create a menu of items
menu_item menu[] = {
    {"Coffee", 50, 0},
    {"Tea", 40, 0},
    {"Juice", 30, 0},
    {"Smoothie", 20, 0},
    {"Pancake", 10, 0}
};

// Function to calculate the total cost of an order
int calculate_total_cost(menu_item *item, int quantity) {
    return item->price * quantity;
}

// Function to generate a bill
void generate_bill(customer *customer, menu_item *item, int total_cost) {
    printf("------------------------------------------------------------------------\n");
    printf("Customer Name: %s\n", customer->name);
    printf("Address: %s\n", customer->address);
    printf("Phone Number: %d\n", customer->phone);
    printf("Order:\n");
    printf("Item: %s, Quantity: %d, Price: %d\n", item->name, item->quantity, item->price);
    printf("Total Cost: %d\n", total_cost);
    printf("Thank you for your visit!\n");
    printf("------------------------------------------------------------------------\n");
}

int main() {
    // Create a customer
    customer customer1;
    strcpy(customer1.name, "John Doe");
    strcpy(customer1.address, "123 Main St.");
    customer1.phone = 5551234;

    // Create an order
    menu_item *item = &menu[0];
    item->quantity = 2;

    // Calculate the total cost of the order
    int total_cost = calculate_total_cost(item, item->quantity);

    // Generate the bill
    generate_bill(&customer1, item, total_cost);

    return 0;
}