//GEMINI-pro DATASET v1.0 Category: Product Inventory System ; Style: genious
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

// Product structure
typedef struct product {
    int id;
    char *name;
    int price;
    int quantity;
} product;

// Product inventory array
product inventory[100];

// Number of products in inventory
int num_products = 0;

// Function to add a product to the inventory
void add_product(product *p) {
    // Check if the array is full
    if (num_products >= 100) {
        printf("Error: The inventory is full.\n");
        return;
    }

    // Add the product to the array
    inventory[num_products++] = *p;

    // Print a success message
    printf("Product added successfully.\n");
}

// Function to search for a product by ID
product *search_product(int id) {
    // Iterate over the array
    for (int i = 0; i < num_products; i++) {
        // Check if the product has the same ID
        if (inventory[i].id == id) {
            // Return the product
            return &inventory[i];
        }
    }

    // Return NULL if the product is not found
    return NULL;
}

// Function to delete a product by ID
void delete_product(int id) {
    // Search for the product
    product *p = search_product(id);

    // Check if the product was found
    if (p == NULL) {
        printf("Error: Product not found.\n");
        return;
    }

    // Shift the array to delete the product
    for (int i = p - inventory; i < num_products - 1; i++) {
        inventory[i] = inventory[i + 1];
    }

    // Decrement the number of products
    num_products--;

    // Print a success message
    printf("Product deleted successfully.\n");
}

// Function to print the inventory
void print_inventory() {
    // Iterate over the array
    for (int i = 0; i < num_products; i++) {
        // Print the product information
        printf("Product %d: %s, %d, %d\n", inventory[i].id, inventory[i].name, inventory[i].price, inventory[i].quantity);
    }
}

// Main function
int main() {
    // Add some products to the inventory
    product p1 = {1, "Apple", 10, 100};
    product p2 = {2, "Orange", 15, 50};
    product p3 = {3, "Banana", 20, 25};
    add_product(&p1);
    add_product(&p2);
    add_product(&p3);

    // Search for a product by ID
    product *p = search_product(2);
    if (p != NULL) {
        printf("Product found: %s, %d, %d\n", p->name, p->price, p->quantity);
    } else {
        printf("Product not found.\n");
    }

    // Delete a product by ID
    delete_product(3);

    // Print the inventory
    print_inventory();

    return 0;
}