//MISTRAL-7B DATASET v1.0 Category: Mailing list manager ; Style: Claude Shannon
#include <stdio.h>
#include <stdint.h>
#include <stdbool.h>
#include <stdlib.h>

#define NUM_SUBSCRIBERS 128
#define SUBSCRIBER_BIT_SIZE (sizeof(uint64_t) * 8)

typedef uint64_t mailing_list;
typedef bool (*subscriber_callback)(int subscriber_id);

void add_subscriber(mailing_list* list, int subscriber_id) {
    *((uint64_t*) list) |= (1ULL << subscriber_id);
}

void remove_subscriber(mailing_list* list, int subscriber_id) {
    *((uint64_t*) list) &= ~(1ULL << subscriber_id);
}

bool is_subscriber(mailing_list list, int subscriber_id, subscriber_callback print_subscriber) {
    bool is_on_list = (*((uint64_t*) &list) & (1ULL << subscriber_id));
    if (is_on_list) {
        print_subscriber(subscriber_id);
    }
    return is_on_list;
}

void print_subscribers(mailing_list list, subscriber_callback print_subscriber) {
    uint64_t current_bit = 0;
    int i = 0;
    for (; i < NUM_SUBSCRIBERS; i++) {
        if (is_subscriber(list, i, print_subscriber)) {
            current_bit++;
            if (current_bit > 8) {
                printf("\n");
                current_bit = 0;
            }
            printf("%d ", i);
        }
    }
    printf("\n");
}

int main() {
    mailing_list mailing_list;
    int subscriber_id;

    add_subscriber(&mailing_list, 0);
    add_subscriber(&mailing_list, 1);

    printf("Subscribers:\n");
    print_subscribers(mailing_list, printf);

    subscriber_id = 1;
    remove_subscriber(&mailing_list, subscriber_id);

    printf("Subscribers after removing subscriber %d:\n", subscriber_id);
    print_subscribers(mailing_list, printf);

    return 0;
}