//GEMINI-pro DATASET v1.0 Category: Graph Coloring Problem ; Style: Romeo and Juliet
#include <stdio.h>
#include <stdlib.h>

// Vertices and colors
#define V 4
#define COLORS 3

// Function to check if the graph coloring is safe
int isSafe(int graph[V][V], int color[], int v, int c) {
  for (int i = 0; i < V; i++) {
    if (graph[v][i] && color[i] == c) {
      return 0;
    }
  }
  return 1;
}

// A recursive function to solve the graph coloring problem
int graphColoring(int graph[V][V], int color[], int m, int v) {
  // If all vertices are colored
  if (v == V) {
    return 1;
  }

  // Try all possible colors
  for (int c = 1; c <= m; c++) {
    // Check if the vertex can be colored with color c
    if (isSafe(graph, color, v, c)) {
      color[v] = c;

      // Recursively color the remaining vertices
      if (graphColoring(graph, color, m, v + 1)) {
        return 1;
      }

      // If assigning color c doesn't lead to a solution, then remove it
      color[v] = 0;
    }
  }

  // If no color can be assigned to this vertex, then there is no solution
  return 0;
}

// Driver program to test the graph coloring function
int main() {
  // Graph adjacency matrix
  int graph[V][V] = {{0, 1, 1, 1}, {1, 0, 1, 0}, {1, 1, 0, 1}, {1, 0, 1, 0}};

  // Initialize all colors to 0
  int color[V];
  for (int i = 0; i < V; i++) {
    color[i] = 0;
  }

  // Number of colors
  int m = COLORS;

  // Solve the graph coloring problem
  if (graphColoring(graph, color, m, 0)) {
    printf("Graph can be colored with %d colors\n", m);
    for (int i = 0; i < V; i++) {
      printf("Vertex %d is colored with color %d\n", i, color[i]);
    }
  } else {
    printf("Graph cannot be colored with %d colors\n", m);
  }

  return 0;
}