//Falcon-180B DATASET v1.0 Category: Maze Route Finder ; Style: ephemeral
#include <stdio.h>
#include <stdlib.h>
#include <time.h>

#define HEIGHT 10
#define WIDTH 10
#define START_X 0
#define START_Y 0
#define END_X 9
#define END_Y 9

void generate_maze(char maze[HEIGHT][WIDTH]);
void print_maze(const char maze[HEIGHT][WIDTH]);
int find_path(char maze[HEIGHT][WIDTH], int x, int y, int dx, int dy);

int main() {
    srand(time(0));
    char maze[HEIGHT][WIDTH];

    generate_maze(maze);
    print_maze(maze);
    int path_length = find_path(maze, START_X, START_Y, END_X, END_Y);
    printf("Path length: %d\n", path_length);

    return 0;
}

void generate_maze(char maze[HEIGHT][WIDTH]) {
    for (int i = 0; i < HEIGHT; ++i) {
        for (int j = 0; j < WIDTH; ++j) {
            maze[i][j] = rand() % 2? '.' : '#';
        }
    }

    int start_x = rand() % WIDTH;
    int start_y = rand() % HEIGHT;
    int end_x = rand() % WIDTH;
    int end_y = rand() % HEIGHT;

    maze[start_y][start_x] = 'S';
    maze[end_y][end_x] = 'E';
}

void print_maze(const char maze[HEIGHT][WIDTH]) {
    for (int i = 0; i < HEIGHT; ++i) {
        for (int j = 0; j < WIDTH; ++j) {
            printf("%c", maze[i][j]);
        }
        printf("\n");
    }
}

int find_path(char maze[HEIGHT][WIDTH], int x, int y, int dx, int dy) {
    int path_length = 0;

    while (x >= 0 && x < WIDTH && y >= 0 && y < HEIGHT && maze[y][x]!= '#') {
        if (maze[y][x] == 'E') {
            return path_length;
        }

        if (maze[y][x] == 'S') {
            path_length = 0;
        }

        int nx = x + dx;
        int ny = y + dy;

        if (nx >= 0 && nx < WIDTH && ny >= 0 && ny < HEIGHT && maze[ny][nx]!= '#') {
            x = nx;
            y = ny;
            ++path_length;
        } else {
            break;
        }
    }

    return -1;
}