//LLAMA2-13B DATASET v1.0 Category: Matrix operations ; Style: standalone
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

// Function to perform matrix multiplication
void matrix_multiply(float (*A)[3], float (*B)[3], float (*C)[3]) {
    int i, j, k;
    for (i = 0; i < 3; i++) {
        for (j = 0; j < 3; j++) {
            for (k = 0; k < 3; k++) {
                C[i][j] += A[i][k] * B[k][j];
            }
        }
    }
}

// Function to perform matrix addition
void matrix_add(float (*A)[3], float (*B)[3], float (*C)[3]) {
    int i, j, k;
    for (i = 0; i < 3; i++) {
        for (j = 0; j < 3; j++) {
            for (k = 0; k < 3; k++) {
                C[i][j] += A[i][k] + B[i][k];
            }
        }
    }
}

int main() {
    float A[3][3] = {{1, 2, 3}, {4, 5, 6}, {7, 8, 9}};
    float B[3][3] = {{10, 20, 30}, {40, 50, 60}, {70, 80, 90}};
    float C[3][3];

    // Perform matrix multiplication
    matrix_multiply(A, B, C);

    // Print the result
    for (int i = 0; i < 3; i++) {
        for (int j = 0; j < 3; j++) {
            printf("%.2f ", C[i][j]);
        }
        printf("\n");
    }

    // Perform matrix addition
    matrix_add(A, B, C);

    // Print the result
    for (int i = 0; i < 3; i++) {
        for (int j = 0; j < 3; j++) {
            printf("%.2f ", C[i][j]);
        }
        printf("\n");
    }

    return 0;
}