//Falcon-180B DATASET v1.0 Category: Maze Route Finder ; Style: satisfied
#include <stdio.h>
#include <stdlib.h>
#include <time.h>

#define ROWS 10
#define COLS 10

void generateMaze(char maze[ROWS][COLS]);
void printMaze(char maze[ROWS][COLS]);
int checkExit(int x, int y);
void solveMaze(char maze[ROWS][COLS]);

int main()
{
    srand(time(NULL));
    char maze[ROWS][COLS];
    
    generateMaze(maze);
    printMaze(maze);
    solveMaze(maze);
    
    return 0;
}

void generateMaze(char maze[ROWS][COLS])
{
    for (int i = 0; i < ROWS; i++)
    {
        for (int j = 0; j < COLS; j++)
        {
            maze[i][j] = rand() % 2? '.' : '#';
        }
    }
}

void printMaze(char maze[ROWS][COLS])
{
    for (int i = 0; i < ROWS; i++)
    {
        for (int j = 0; j < COLS; j++)
        {
            printf("%c ", maze[i][j]);
        }
        printf("\n");
    }
}

int checkExit(int x, int y)
{
    if (x == 0 || x == COLS - 1 || y == 0 || y == ROWS - 1)
    {
        return 1;
    }
    return 0;
}

void solveMaze(char maze[ROWS][COLS])
{
    int startX = 0, startY = 0;
    int endX = COLS - 1, endY = ROWS - 1;

    while (!checkExit(startX, startY) &&!checkExit(endX, endY))
    {
        int dirX = rand() % 2? -1 : 1;
        int dirY = rand() % 2? -1 : 1;

        int newX = startX + dirX;
        int newY = startY + dirY;

        if (maze[newX][newY] == '.')
        {
            maze[startX][startY] = '.';
            maze[newX][newY] = '*';
            startX = newX;
            startY = newY;
        }
    }

    maze[endX][endY] = 'E';
    maze[startX][startY] = 'S';
}