//Falcon-180B DATASET v1.0 Category: Medical Store Management System ; Style: synchronous
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <ctype.h>

#define MAX_ITEMS 100
#define MAX_ITEM_NAME_LENGTH 50
#define MAX_ITEM_DESC_LENGTH 100
#define MAX_ITEM_PRICE 10000

typedef struct {
    char name[MAX_ITEM_NAME_LENGTH];
    char description[MAX_ITEM_DESC_LENGTH];
    int price;
    int quantity;
} Item;

Item items[MAX_ITEMS];
int numItems = 0;

void addItem(char* name, char* description, int price, int quantity) {
    strcpy(items[numItems].name, name);
    strcpy(items[numItems].description, description);
    items[numItems].price = price;
    items[numItems].quantity = quantity;
    numItems++;
}

void displayItems() {
    printf("Item Name\tDescription\tPrice\tQuantity\n");
    for (int i = 0; i < numItems; i++) {
        printf("%-50s\t%-100s\t%d\t%d\n", items[i].name, items[i].description, items[i].price, items[i].quantity);
    }
}

void searchItem(char* name) {
    for (int i = 0; i < numItems; i++) {
        if (strcmp(items[i].name, name) == 0) {
            printf("Item Name: %s\n", items[i].name);
            printf("Description: %s\n", items[i].description);
            printf("Price: %d\n", items[i].price);
            printf("Quantity: %d\n", items[i].quantity);
        }
    }
}

int main() {
    addItem("Aspirin", "Pain reliever", 50, 100);
    addItem("Ibuprofen", "Pain reliever", 75, 50);
    addItem("Bandages", "Wound protection", 25, 200);
    displayItems();
    searchItem("Aspirin");
    return 0;
}