//GPT-4o-mini DATASET v1.0 Category: Database querying ; Style: beginner-friendly
#include <stdio.h>
#include <stdlib.h>
#include <sqlite3.h>

// Callback function to display the results of the query
static int callback(void *data, int argc, char **argv, char **azColName) {
    for (int i = 0; i < argc; i++) {
        printf("%s = %s\n", azColName[i], argv[i] ? argv[i] : "NULL");
    }
    printf("\n");
    return 0;
}

// Function to execute SQL commands
void execute_sql(sqlite3 *db, const char *sql) {
    char *errMsg;
    int ret = sqlite3_exec(db, sql, callback, 0, &errMsg);
    if (ret != SQLITE_OK) {
        fprintf(stderr, "SQL error: %s\n", errMsg);
        sqlite3_free(errMsg);
    } else {
        printf("Operation executed successfully\n");
    }
}

int main() {
    sqlite3 *db;
    char *errMsg = 0;

    // Open database
    if (sqlite3_open("test.db", &db)) {
        fprintf(stderr, "Can't open database: %s\n", sqlite3_errmsg(db));
        return 1;
    }
    printf("Opened database successfully\n");

    // Create SQL table
    const char *sql_create_table = "CREATE TABLE IF NOT EXISTS Users("
                                    "ID INTEGER PRIMARY KEY AUTOINCREMENT, "
                                    "Name TEXT NOT NULL, "
                                    "Email TEXT NOT NULL UNIQUE);";
    execute_sql(db, sql_create_table);

    // Insert some users
    const char *sql_insert_user1 = "INSERT INTO Users (Name, Email) VALUES ('Alice', 'alice@example.com');";
    const char *sql_insert_user2 = "INSERT INTO Users (Name, Email) VALUES ('Bob', 'bob@example.com');";
    execute_sql(db, sql_insert_user1);
    execute_sql(db, sql_insert_user2);

    // Query users
    const char *sql_query_users = "SELECT * FROM Users;";
    execute_sql(db, sql_query_users);

    // Close the database
    sqlite3_close(db);
    return 0;
}