//Falcon-180B DATASET v1.0 Category: Benchmarking ; Style: asynchronous
#include <stdio.h>
#include <stdlib.h>
#include <pthread.h>

#define NUM_THREADS 4

// Function to be executed by each thread
void *runner(void *param);

// Global variables shared among threads
int shared_variable = 0;
pthread_mutex_t mutex = PTHREAD_MUTEX_INITIALIZER;

int main() {
    pthread_t threads[NUM_THREADS];
    int i, rc;

    // Create threads
    for (i = 0; i < NUM_THREADS; i++) {
        rc = pthread_create(&threads[i], NULL, runner, NULL);
        if (rc) {
            printf("Error: unable to create thread, %d\n", rc);
            exit(-1);
        }
    }

    // Join with threads
    for (i = 0; i < NUM_THREADS; i++) {
        rc = pthread_join(threads[i], NULL);
        if (rc) {
            printf("Error: unable to join with thread, %d\n", rc);
            exit(-1);
        }
    }

    printf("Shared variable: %d\n", shared_variable);

    return 0;
}

// Function to be executed by each thread
void *runner(void *param) {
    int id = (int) param;

    pthread_mutex_lock(&mutex);
    shared_variable++;
    printf("Thread %d incremented shared variable\n", id);
    pthread_mutex_unlock(&mutex);

    return NULL;
}