//Falcon-180B DATASET v1.0 Category: Memory management ; Style: introspective
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

// Struct to hold data about a person
typedef struct {
    char* name;
    int age;
    char* gender;
} Person;

// Function to allocate memory for a new person struct
Person* createPerson(char* name, int age, char* gender) {
    Person* newPerson = (Person*) malloc(sizeof(Person));
    if (newPerson == NULL) {
        printf("Error: Could not allocate memory for new person.\n");
        return NULL;
    }
    newPerson->name = strdup(name);
    newPerson->age = age;
    newPerson->gender = strdup(gender);
    return newPerson;
}

// Function to print information about a person
void printPerson(Person* person) {
    printf("Name: %s\n", person->name);
    printf("Age: %d\n", person->age);
    printf("Gender: %s\n", person->gender);
}

// Function to free memory used by a person struct
void deletePerson(Person* person) {
    free(person->name);
    free(person->gender);
    free(person);
}

int main() {
    // Create a new person
    Person* newPerson = createPerson("John Doe", 30, "Male");
    if (newPerson == NULL) {
        return 1;
    }

    // Print information about the new person
    printPerson(newPerson);

    // Delete the person and free memory
    deletePerson(newPerson);

    return 0;
}