//Falcon-180B DATASET v1.0 Category: Airport Baggage Handling Simulation ; Style: portable
#include <stdio.h>
#include <stdlib.h>
#include <time.h>

#define NUM_BAGS 10
#define MAX_BAGS 100
#define NUM_CAROUSELS 3
#define MAX_CAROUSELS 10
#define TIME_PER_BAG 2

typedef struct {
    int id;
    int carousel;
    int time_left;
} Bag;

void init_bags(Bag bags[], int num_bags) {
    int i;
    srand(time(NULL));
    for (i = 0; i < num_bags; i++) {
        bags[i].id = i + 1;
        bags[i].carousel = rand() % NUM_CAROUSELS;
        bags[i].time_left = TIME_PER_BAG;
    }
}

void print_bags(Bag bags[], int num_bags) {
    int i;
    for (i = 0; i < num_bags; i++) {
        printf("Bag %d is on carousel %d with %d seconds left.\n", bags[i].id, bags[i].carousel, bags[i].time_left);
    }
}

void move_bags(Bag bags[], int num_bags) {
    int i;
    for (i = 0; i < num_bags; i++) {
        bags[i].time_left--;
        if (bags[i].time_left == 0) {
            printf("Bag %d has been on carousel %d for too long. Moving to lost and found.\n", bags[i].id, bags[i].carousel);
        }
    }
}

int main() {
    Bag bags[NUM_BAGS];
    init_bags(bags, NUM_BAGS);

    int i;
    for (i = 0; i < 10; i++) {
        printf("Round %d:\n", i + 1);
        print_bags(bags, NUM_BAGS);
        move_bags(bags, NUM_BAGS);
        printf("\n");
    }

    return 0;
}