//Falcon-180B DATASET v1.0 Category: Banking Record System ; Style: shape shifting
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#define MAX_ACCOUNTS 100
#define MAX_TRANSACTIONS 1000

typedef struct {
    int accountNumber;
    char name[50];
    double balance;
} Account;

typedef struct {
    int fromAccount;
    int toAccount;
    double amount;
    char type[10];
} Transaction;

int numAccounts;
Account accounts[MAX_ACCOUNTS];
int numTransactions;
Transaction transactions[MAX_TRANSACTIONS];

void createAccount(int accountNumber, char* name) {
    accounts[numAccounts].accountNumber = accountNumber;
    strcpy(accounts[numAccounts].name, name);
    accounts[numAccounts].balance = 0.0;
    numAccounts++;
}

int findAccount(int accountNumber) {
    for(int i=0; i<numAccounts; i++) {
        if(accounts[i].accountNumber == accountNumber) {
            return i;
        }
    }
    return -1;
}

void deposit(int accountNumber, double amount) {
    int index = findAccount(accountNumber);
    if(index!= -1) {
        accounts[index].balance += amount;
    }
}

void withdraw(int accountNumber, double amount) {
    int index = findAccount(accountNumber);
    if(index!= -1) {
        if(accounts[index].balance >= amount) {
            accounts[index].balance -= amount;
        } else {
            printf("Insufficient funds\n");
        }
    }
}

void transfer(int fromAccount, int toAccount, double amount) {
    int fromIndex = findAccount(fromAccount);
    int toIndex = findAccount(toAccount);

    if(fromIndex!= -1 && toIndex!= -1) {
        if(accounts[fromIndex].balance >= amount) {
            accounts[fromIndex].balance -= amount;
            accounts[toIndex].balance += amount;
        } else {
            printf("Insufficient funds\n");
        }
    }
}

void addTransaction(int fromAccount, int toAccount, double amount, char* type) {
    Transaction transaction;
    transaction.fromAccount = fromAccount;
    transaction.toAccount = toAccount;
    transaction.amount = amount;
    strcpy(transaction.type, type);
    transactions[numTransactions++] = transaction;
}

void printTransactions() {
    for(int i=0; i<numTransactions; i++) {
        printf("Transaction #%d: %s %d to %d - $%.2f\n", i+1, transactions[i].type, transactions[i].fromAccount, transactions[i].toAccount, transactions[i].amount);
    }
}

int main() {
    numAccounts = 0;
    createAccount(1, "John Doe");
    createAccount(2, "Jane Doe");

    deposit(1, 1000);
    deposit(2, 2000);

    withdraw(1, 500);

    transfer(1, 2, 750);

    addTransaction(1, 2, 750, "Transfer");

    printTransactions();

    return 0;
}