//Falcon-180B DATASET v1.0 Category: Email Client ; Style: accurate
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <ctype.h>
#include <time.h>

#define MAX_EMAIL_SIZE 1024
#define SUBJECT_MAX_LENGTH 100
#define RECIPIENT_MAX_LENGTH 100
#define SENDER_MAX_LENGTH 100
#define BODY_MAX_LENGTH 1000

typedef struct {
    char subject[SUBJECT_MAX_LENGTH];
    char recipient[RECIPIENT_MAX_LENGTH];
    char sender[SENDER_MAX_LENGTH];
    char body[BODY_MAX_LENGTH];
    time_t timestamp;
} Email;

Email emails[100];
int num_emails = 0;

void add_email(Email* email) {
    if (num_emails >= 100) {
        printf("Error: Email inbox is full.\n");
        return;
    }

    strcpy(emails[num_emails].subject, email->subject);
    strcpy(emails[num_emails].recipient, email->recipient);
    strcpy(emails[num_emails].sender, email->sender);
    strcpy(emails[num_emails].body, email->body);
    emails[num_emails].timestamp = time(NULL);

    num_emails++;
}

void print_email_list() {
    printf("Email Inbox:\n");
    printf("--------------------\n");

    for (int i = 0; i < num_emails; i++) {
        printf("%d. %s\n", i+1, emails[i].subject);
    }
}

void print_email(int index) {
    if (index < 0 || index >= num_emails) {
        printf("Error: Invalid email index.\n");
        return;
    }

    printf("Subject: %s\n", emails[index].subject);
    printf("Recipient: %s\n", emails[index].recipient);
    printf("Sender: %s\n", emails[index].sender);
    printf("Body:\n%s\n", emails[index].body);
    printf("Timestamp: %s\n", ctime(&emails[index].timestamp));
}

int main() {
    // Add some emails to the inbox
    add_email(&(Email){
       .subject = "Hello, World!",
       .recipient = "recipient@example.com",
       .sender = "sender@example.com",
       .body = "This is a test email."
    });

    add_email(&(Email){
       .subject = "Test Email",
       .recipient = "recipient2@example.com",
       .sender = "sender2@example.com",
       .body = "This is another test email."
    });

    // Print the email list
    print_email_list();

    // Print a specific email
    print_email(0);

    return 0;
}