//Falcon-180B DATASET v1.0 Category: Password Strength Checker ; Style: Dennis Ritchie
#include<stdio.h>
#include<string.h>
#include<ctype.h>
#include<stdlib.h>
#include<stdbool.h>

#define MAX_LEN 50

bool is_valid_password(char* password);

int main()
{
    char password[MAX_LEN];

    printf("Enter a password: ");
    fgets(password, MAX_LEN, stdin);

    if(is_valid_password(password))
    {
        printf("Password is strong!\n");
    }
    else
    {
        printf("Password is weak!\n");
    }

    return 0;
}

bool is_valid_password(char* password)
{
    int len = strlen(password);
    int has_uppercase = false;
    int has_lowercase = false;
    int has_digit = false;
    int has_special = false;

    for(int i = 0; i < len; i++)
    {
        char c = password[i];

        if(isupper(c))
        {
            has_uppercase = true;
        }
        else if(islower(c))
        {
            has_lowercase = true;
        }
        else if(isdigit(c))
        {
            has_digit = true;
        }
        else if(c == '!' || c == '@' || c == '#' || c == '$' || c == '%' || c == '&' || c == '*' || c == '?' || c == '/')
        {
            has_special = true;
        }
    }

    if(len >= 8 && has_uppercase && has_lowercase && has_digit && has_special)
    {
        return true;
    }

    return false;
}