//Gemma-7B DATASET v1.0 Category: Banking Record System ; Style: protected
#include <stdio.h>
#include <string.h>
#include <stdlib.h>

#define MAX_CUSTOMERS 10

typedef struct Customer {
    char name[50];
    int account_number;
    double balance;
} Customer;

Customer customers[MAX_CUSTOMERS];

void deposit(int account_number, double amount) {
    for (int i = 0; i < MAX_CUSTOMERS; i++) {
        if (customers[i].account_number == account_number) {
            customers[i].balance += amount;
            break;
        }
    }
}

void withdraw(int account_number, double amount) {
    for (int i = 0; i < MAX_CUSTOMERS; i++) {
        if (customers[i].account_number == account_number) {
            if (amount <= customers[i].balance) {
                customers[i].balance -= amount;
                break;
            } else {
                printf("Insufficient funds.\n");
            }
        }
    }
}

void transfer(int from_account_number, int to_account_number, double amount) {
    for (int i = 0; i < MAX_CUSTOMERS; i++) {
        if (customers[i].account_number == from_account_number) {
            if (amount <= customers[i].balance) {
                deposit(to_account_number, amount);
                customers[i].balance -= amount;
                break;
            } else {
                printf("Insufficient funds.\n");
            }
        }
    }
}

int main() {
    deposit(123, 500);
    withdraw(123, 200);
    transfer(123, 456, 100);

    for (int i = 0; i < MAX_CUSTOMERS; i++) {
        printf("Name: %s, Account Number: %d, Balance: %.2lf\n", customers[i].name, customers[i].account_number, customers[i].balance);
    }

    return 0;
}