//Falcon-180B DATASET v1.0 Category: Building a HTTP Client ; Style: multi-threaded
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <curl/curl.h>
#include <pthread.h>

#define NUM_THREADS 5

struct thread_data {
    CURL *curl;
    char url[100];
};

size_t write_data(void *ptr, size_t size, size_t nmemb, void *userp) {
    return size * nmemb;
}

void *thread_func(void *arg) {
    struct thread_data *thread_data = (struct thread_data *) arg;
    CURLcode res;

    curl_easy_setopt(thread_data->curl, CURLOPT_URL, thread_data->url);
    curl_easy_setopt(thread_data->curl, CURLOPT_WRITEFUNCTION, write_data);

    res = curl_easy_perform(thread_data->curl);

    if(res!= CURLE_OK) {
        fprintf(stderr, "Thread %d: curl_easy_perform() failed: %s\n", (int)pthread_self(), curl_easy_strerror(res));
    }

    curl_easy_cleanup(thread_data->curl);
    free(thread_data);

    return NULL;
}

int main() {
    CURL *curl;
    CURLM *curlm;
    struct thread_data thread_data[NUM_THREADS];
    pthread_t threads[NUM_THREADS];

    curl_global_init(CURL_GLOBAL_DEFAULT);
    curl = curl_easy_init();

    if(curl) {
        curlm = curl_multi_init();

        if(curlm) {
            int still_running = 0;

            for(int i = 0; i < NUM_THREADS; i++) {
                sprintf(thread_data[i].url, "http://example.com/page%d", i + 1);
                thread_data[i].curl = curl_easy_init();

                if(thread_data[i].curl) {
                    curl_multi_add_handle(curlm, thread_data[i].curl);
                }
            }

            do {
                CURLMcode mc = curl_multi_perform(curlm, &still_running);

                if(mc!= CURLM_OK) {
                    fprintf(stderr, "curl_multi_perform() failed: %s\n", curl_multi_strerror(mc));
                }
            } while(still_running);

            for(int i = 0; i < NUM_THREADS; i++) {
                curl_multi_remove_handle(curlm, thread_data[i].curl);
                curl_easy_cleanup(thread_data[i].curl);
            }

            curl_multi_cleanup(curlm);
        }

        curl_easy_cleanup(curl);
    }

    curl_global_cleanup();

    return 0;
}