//Code Llama-13B DATASET v1.0 Category: Bingo Simulator ; Style: shape shifting
/*
 * Bingo Simulator
 * Written in a shape shifting style
 */

#include <stdio.h>
#include <stdlib.h>
#include <time.h>

#define NUM_CARDS 5
#define NUM_BINGO_NUMBERS 75

typedef struct {
    int numbers[NUM_BINGO_NUMBERS];
    int card[NUM_CARDS][5];
} BingoCard;

void generate_bingo_card(BingoCard *card) {
    // Generate random numbers for the bingo card
    for (int i = 0; i < NUM_BINGO_NUMBERS; i++) {
        card->numbers[i] = rand() % 75 + 1;
    }

    // Shuffle the numbers
    for (int i = 0; i < NUM_BINGO_NUMBERS; i++) {
        int random_index = rand() % (NUM_BINGO_NUMBERS - i) + i;
        int temp = card->numbers[random_index];
        card->numbers[random_index] = card->numbers[i];
        card->numbers[i] = temp;
    }

    // Generate the bingo card
    for (int i = 0; i < NUM_CARDS; i++) {
        for (int j = 0; j < 5; j++) {
            card->card[i][j] = card->numbers[j + (i * 5)];
        }
    }
}

void print_bingo_card(BingoCard *card) {
    for (int i = 0; i < NUM_CARDS; i++) {
        for (int j = 0; j < 5; j++) {
            printf("%d ", card->card[i][j]);
        }
        printf("\n");
    }
}

int main() {
    BingoCard card;
    generate_bingo_card(&card);
    print_bingo_card(&card);
    return 0;
}