//LLAMA2-13B DATASET v1.0 Category: Port Scanner ; Style: puzzling
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <arpa/inet.h>
#include <sys/socket.h>
#include <netinet/in.h>

#define PORT_RANGE 1024

int main(void) {
    int sock, port;
    struct sockaddr_in server, client;
    socklen_t client_len = sizeof(client);
    char buffer[1024];

    // Step 1: Create a socket
    sock = socket(AF_INET, SOCK_STREAM, 0);
    if (sock < 0) {
        perror("socket failed");
        exit(EXIT_FAILURE);
    }

    // Step 2: Set up the server address
    memset(&server, 0, sizeof(server));
    server.sin_family = AF_INET;
    server.sin_addr.s_addr = htonl(INADDR_ANY);
    server.sin_port = htons(0);

    // Step 3: Bind the socket to a port
    if (bind(sock, (struct sockaddr *)&server, sizeof(server)) < 0) {
        perror("bind failed");
        exit(EXIT_FAILURE);
    }

    // Step 4: Listen for incoming connections
    if (listen(sock, PORT_RANGE) < 0) {
        perror("listen failed");
        exit(EXIT_FAILURE);
    }

    // Step 5: Accept an incoming connection
    if ((port = accept(sock, (struct sockaddr *)&client, &client_len)) < 0) {
        perror("accept failed");
        exit(EXIT_FAILURE);
    }

    // Step 6: Read data from the client
    read(port, buffer, 1024);

    // Step 7: Print the received data
    printf("Received data: %s\n", buffer);

    // Step 8: Close the socket
    close(port);

    return 0;
}