//Gemma-7B DATASET v1.0 Category: Resume Parsing System ; Style: authentic
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#define MAX_NAME_LENGTH 255

typedef struct Resume
{
    char name[MAX_NAME_LENGTH];
    int age;
    float salary;
    char* occupation;
} Resume;

void parse_resume(char* resume_text)
{
    Resume resume;

    // Extract the name
    char* name_start = strstr(resume_text, "Name:");
    if (name_start)
    {
        name_start += 5; // Skip "Name:" and whitespace
        char* name_end = strstr(name_start, ",");
        if (name_end)
        {
            int name_length = name_end - name_start;
            strncpy(resume.name, name_start, name_length);
        }
    }

    // Extract the age
    char* age_start = strstr(resume_text, "Age:");
    if (age_start)
    {
        age_start += 5; // Skip "Age:" and whitespace
        char* age_end = strstr(age_start, ":");
        if (age_end)
        {
            int age_length = age_end - age_start;
            resume.age = atoi(age_start);
        }
    }

    // Extract the salary
    char* salary_start = strstr(resume_text, "Salary:");
    if (salary_start)
    {
        salary_start += 8; // Skip "Salary:" and whitespace
        char* salary_end = strstr(salary_start, "$");
        if (salary_end)
        {
            int salary_length = salary_end - salary_start;
            resume.salary = atof(salary_start);
        }
    }

    // Extract the occupation
    char* occupation_start = strstr(resume_text, "Occupation:");
    if (occupation_start)
    {
        occupation_start += 11; // Skip "Occupation:" and whitespace
        char* occupation_end = strstr(occupation_start, ".");
        if (occupation_end)
        {
            int occupation_length = occupation_end - occupation_start;
            resume.occupation = malloc(occupation_length);
            strncpy(resume.occupation, occupation_start, occupation_length);
        }
    }

    // Print the resume information
    printf("Name: %s\n", resume.name);
    printf("Age: %d\n", resume.age);
    printf("Salary: %.2f\n", resume.salary);
    printf("Occupation: %s\n", resume.occupation);
}

int main()
{
    char* resume_text = "Name: John Doe\nAge: 25\nSalary: $50,000\nOccupation: Software Engineer";

    parse_resume(resume_text);

    return 0;
}