//Falcon2-11B DATASET v1.0 Category: Hotel Management System ; Style: calm
#include <stdio.h>
#include <stdlib.h>
#include <stdbool.h>

// Structure to represent a room
struct Room {
    char name[50];
    bool occupied;
};

// Structure to represent a guest
struct Guest {
    char name[50];
    char room[50];
};

// Function to print room information
void printRoomInfo(struct Room room) {
    printf("Room: %s\n", room.name);
    printf("Occupied: %s\n", room.occupied? "Yes" : "No");
}

// Function to check if a room is available
bool isRoomAvailable(struct Room room) {
    return!room.occupied;
}

// Function to check in a guest
void checkInGuest(struct Room room, struct Guest guest) {
    room.occupied = true;
    printf("Guest %s checked in to room %s\n", guest.name, room.name);
}

// Function to check out a guest
void checkOutGuest(struct Room room, struct Guest guest) {
    room.occupied = false;
    printf("Guest %s checked out from room %s\n", guest.name, room.name);
}

// Function to handle room service requests
void handleRoomServiceRequest(struct Room room, struct Guest guest) {
    printf("Guest %s requested room service for room %s\n", guest.name, room.name);
}

int main() {
    // Create some rooms
    struct Room room1 = {"Room 1", false};
    struct Room room2 = {"Room 2", true};
    struct Room room3 = {"Room 3", false};

    // Create some guests
    struct Guest guest1 = {"John Doe", "Room 1"};
    struct Guest guest2 = {"Jane Doe", "Room 2"};

    // Print initial room information
    printRoomInfo(room1);
    printRoomInfo(room2);
    printRoomInfo(room3);

    // Check in guest1
    checkInGuest(room1, guest1);

    // Print updated room information
    printRoomInfo(room1);
    printRoomInfo(room2);
    printRoomInfo(room3);

    // Check out guest2
    checkOutGuest(room2, guest2);

    // Print updated room information
    printRoomInfo(room1);
    printRoomInfo(room2);
    printRoomInfo(room3);

    // Handle room service request for room1
    handleRoomServiceRequest(room1, guest1);

    // Print updated room information
    printRoomInfo(room1);
    printRoomInfo(room2);
    printRoomInfo(room3);

    return 0;
}