//Gemma-7B DATASET v1.0 Category: Haunted House Simulator ; Style: visionary
#include <stdlib.h>
#include <stdio.h>
#include <time.h>

#define MAX_GHOULS 5

typedef struct Ghost {
    char name[20];
    int room_num;
    int personality;
    int is_active;
} Ghost;

Ghost ghosts[MAX_GHOULS];

void initializeGhosts() {
    for (int i = 0; i < MAX_GHOULS; i++) {
        ghosts[i].name[0] = '\0';
        ghosts[i].room_num = -1;
        ghosts[i].personality = -1;
        ghosts[i].is_active = 0;
    }
}

void spawnGhost() {
    int new_ghost = -1;
    for (int i = 0; i < MAX_GHOULS && new_ghost == -1; i++) {
        if (!ghosts[i].is_active) {
            new_ghost = i;
        }
    }

    if (new_ghost != -1) {
        ghosts[new_ghost].name[0] = 'A' + new_ghost;
        ghosts[new_ghost].room_num = rand() % 5 + 1;
        ghosts[new_ghost].personality = rand() % 3;
        ghosts[new_ghost].is_active = 1;
    }
}

int main() {
    initializeGhosts();

    for (int i = 0; i < 10; i++) {
        spawnGhost();
    }

    for (int i = 0; i < MAX_GHOULS; i++) {
        printf("Ghost %c: Room %d, Personality %d, Active %d\n", ghosts[i].name[0], ghosts[i].room_num, ghosts[i].personality, ghosts[i].is_active);
    }

    return 0;
}