//Falcon-180B DATASET v1.0 Category: File system simulation ; Style: modular
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#define MAX_FILES 100
#define MAX_FILE_NAME_LENGTH 50

typedef struct {
    char name[MAX_FILE_NAME_LENGTH];
    char content[100];
} File;

File files[MAX_FILES];
int num_files = 0;

void create_file(char *name) {
    strcpy(files[num_files].name, name);
    files[num_files].content[0] = '\0';
    num_files++;
}

void delete_file(char *name) {
    int i;
    for (i = 0; i < num_files; i++) {
        if (strcmp(files[i].name, name) == 0) {
            memset(files[i].content, '\0', strlen(files[i].content));
            strcpy(files[i].name, "");
            num_files--;
            return;
        }
    }
    printf("File not found.\n");
}

void rename_file(char *old_name, char *new_name) {
    int i;
    for (i = 0; i < num_files; i++) {
        if (strcmp(files[i].name, old_name) == 0) {
            strcpy(files[i].name, new_name);
            return;
        }
    }
    printf("File not found.\n");
}

void write_to_file(char *name, char *content) {
    int i;
    for (i = 0; i < num_files; i++) {
        if (strcmp(files[i].name, name) == 0) {
            strcat(files[i].content, content);
            return;
        }
    }
    printf("File not found.\n");
}

void read_from_file(char *name) {
    int i;
    for (i = 0; i < num_files; i++) {
        if (strcmp(files[i].name, name) == 0) {
            printf("%s", files[i].content);
            return;
        }
    }
    printf("File not found.\n");
}

int main() {
    create_file("test.txt");
    write_to_file("test.txt", "Hello, world!");
    read_from_file("test.txt");
    rename_file("test.txt", "hello.txt");
    read_from_file("hello.txt");
    delete_file("hello.txt");
    return 0;
}