//GEMINI-pro DATASET v1.0 Category: Pixel Art Generator ; Style: all-encompassing
#include <stdio.h>
#include <stdlib.h>
#include <math.h>

#define WIDTH 640
#define HEIGHT 480

unsigned char pixels[WIDTH * HEIGHT * 3];

void draw_line(int x0, int y0, int x1, int y1, unsigned char r, unsigned char g, unsigned char b) {
    int dx = abs(x1 - x0), sx = x0 < x1 ? 1 : -1;
    int dy = abs(y1 - y0), sy = y0 < y1 ? 1 : -1;
    int err = (dx > dy ? dx : -dy) / 2;

    while (1) {
        pixels[(y0 * WIDTH + x0) * 3] = r;
        pixels[(y0 * WIDTH + x0) * 3 + 1] = g;
        pixels[(y0 * WIDTH + x0) * 3 + 2] = b;

        if (x0 == x1 && y0 == y1) break;
        int e2 = err;
        if (e2 > -dx) { err -= dy; x0 += sx; }
        if (e2 < dy) { err += dx; y0 += sy; }
    }
}

void draw_circle(int cx, int cy, int r, unsigned char r1, unsigned char g1, unsigned char b1, unsigned char r2, unsigned char g2, unsigned char b2) {
    int x = 0, y = r;
    int dx = 1, dy = -2 * r;

    while (x <= y) {
        draw_line(cx - x, cy - y, cx + x, cy - y, r1, g1, b1);
        draw_line(cx - x, cy + y, cx + x, cy + y, r2, g2, b2);
        draw_line(cx - y, cy - x, cx + y, cy - x, r1, g1, b1);
        draw_line(cx - y, cy + x, cx + y, cy + x, r2, g2, b2);

        if (dy < 0) {
            dy += 2 * x + 1;
        } else {
            dy += 2 * (x - y) + 1;
            y--;
        }

        x++;
    }
}

int main() {
    FILE *fp = fopen("output.ppm", "wb");
    if (fp == NULL) {
        perror("fopen");
        return EXIT_FAILURE;
    }

    fprintf(fp, "P6\n%d %d\n255\n", WIDTH, HEIGHT);
    fwrite(pixels, 1, WIDTH * HEIGHT * 3, fp);
    fclose(fp);

    return EXIT_SUCCESS;
}