//Falcon-180B DATASET v1.0 Category: Modern Encryption ; Style: surrealist
#include <stdio.h>
#include <stdlib.h>
#include <time.h>

#define N 16

void print_matrix(int matrix[N][N]) {
    for (int i = 0; i < N; i++) {
        for (int j = 0; j < N; j++) {
            printf("%d ", matrix[i][j]);
        }
        printf("\n");
    }
}

void multiply_matrices(int matrix1[N][N], int matrix2[N][N], int result[N][N]) {
    for (int i = 0; i < N; i++) {
        for (int j = 0; j < N; j++) {
            for (int k = 0; k < N; k++) {
                result[i][j] += matrix1[i][k] * matrix2[k][j];
            }
        }
    }
}

void encrypt(int message[N][N], int key[N][N], int encrypted[N][N]) {
    for (int i = 0; i < N; i++) {
        for (int j = 0; j < N; j++) {
            encrypted[i][j] = message[i][j] ^ key[i][j];
        }
    }
}

void decrypt(int encrypted[N][N], int key[N][N], int decrypted[N][N]) {
    for (int i = 0; i < N; i++) {
        for (int j = 0; j < N; j++) {
            decrypted[i][j] = encrypted[i][j] ^ key[i][j];
        }
    }
}

int main() {
    srand(time(NULL));
    int message[N][N];
    int key[N][N];
    int encrypted[N][N];
    int decrypted[N][N];

    // Fill message with random values
    for (int i = 0; i < N; i++) {
        for (int j = 0; j < N; j++) {
            message[i][j] = rand() % 256;
        }
    }

    // Fill key with random values
    for (int i = 0; i < N; i++) {
        for (int j = 0; j < N; j++) {
            key[i][j] = rand() % 256;
        }
    }

    // Encrypt message
    encrypt(message, key, encrypted);

    // Print encrypted message
    printf("Encrypted message:\n");
    print_matrix(encrypted);

    // Decrypt message
    decrypt(encrypted, key, decrypted);

    // Print decrypted message
    printf("\nDecrypted message:\n");
    print_matrix(decrypted);

    return 0;
}