//GEMINI-pro DATASET v1.0 Category: Data mining ; Style: happy
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

// A happy data mining example!

// Define a struct to represent a data point.
typedef struct {
  int age;
  char *gender;
  char *occupation;
  int salary;
} data_point;

// Create a dataset of data points.
data_point dataset[] = {
  { 20, "male", "student", 10000 },
  { 30, "female", "doctor", 50000 },
  { 40, "male", "lawyer", 100000 },
  { 50, "female", "teacher", 40000 },
  { 60, "male", "retired", 20000 }
};

// Get the number of data points in the dataset.
int num_data_points = sizeof(dataset) / sizeof(data_point);

// Print the dataset.
void print_dataset() {
  for (int i = 0; i < num_data_points; i++) {
    printf("Data point %d:\n", i + 1);
    printf("  age: %d\n", dataset[i].age);
    printf("  gender: %s\n", dataset[i].gender);
    printf("  occupation: %s\n", dataset[i].occupation);
    printf("  salary: %d\n", dataset[i].salary);
    printf("\n");
  }
}

// Find the average salary for all the data points.
int get_average_salary() {
  int total_salary = 0;
  for (int i = 0; i < num_data_points; i++) {
    total_salary += dataset[i].salary;
  }
  return total_salary / num_data_points;
}

// Find the most common occupation for all the data points.
char *get_most_common_occupation() {
  char *most_common_occupation = NULL;
  int max_count = 0;
  for (int i = 0; i < num_data_points; i++) {
    int count = 0;
    for (int j = 0; j < num_data_points; j++) {
      if (strcmp(dataset[i].occupation, dataset[j].occupation) == 0) {
        count++;
      }
    }
    if (count > max_count) {
      max_count = count;
      most_common_occupation = dataset[i].occupation;
    }
  }
  return most_common_occupation;
}

// Print the results of the data mining.
void print_results() {
  printf("The average salary is: %d\n", get_average_salary());
  printf("The most common occupation is: %s\n", get_most_common_occupation());
}

// Main function.
int main() {
  // Print the dataset.
  print_dataset();

  // Get the results of the data mining.
  print_results();

  return 0;
}