//Falcon-180B DATASET v1.0 Category: Database simulation ; Style: surprised
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#define MAX_RECORDS 1000
#define MAX_NAME_LEN 50
#define MAX_AGE 120

// Define the structure for a record
typedef struct {
    char name[MAX_NAME_LEN];
    int age;
} Record;

// Function to add a new record to the database
void addRecord(Record *database, int numRecords, char *name, int age) {
    if (numRecords >= MAX_RECORDS) {
        printf("Error: Database is full!\n");
        return;
    }

    strcpy(database[numRecords].name, name);
    database[numRecords].age = age;
    numRecords++;
}

// Function to search for a record by name
int searchRecord(Record *database, int numRecords, char *name) {
    int i;

    for (i = 0; i < numRecords; i++) {
        if (strcmp(database[i].name, name) == 0) {
            return i;
        }
    }

    return -1;
}

// Function to print all records in the database
void printRecords(Record *database, int numRecords) {
    int i;

    for (i = 0; i < numRecords; i++) {
        printf("Name: %s, Age: %d\n", database[i].name, database[i].age);
    }
}

int main() {
    Record database[MAX_RECORDS];
    int numRecords = 0;

    addRecord(database, numRecords, "John Doe", 30);
    addRecord(database, numRecords, "Jane Smith", 25);
    addRecord(database, numRecords, "Bob Johnson", 40);

    printRecords(database, numRecords);

    int searchIndex = searchRecord(database, numRecords, "Jane Smith");

    if (searchIndex!= -1) {
        printf("Found record for %s at index %d\n", "Jane Smith", searchIndex);
    } else {
        printf("Record not found.\n");
    }

    return 0;
}