//GPT-4o-mini DATASET v1.0 Category: Network Packet Monitoring ; Style: calm
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <pcap.h>
#include <arpa/inet.h>

#define SIZE_ETHERNET 14
#define ETHER_ADDR_LEN 6

// Define Ethernet header structure
struct ethernet_header {
    u_char dest_addr[ETHER_ADDR_LEN];    // Destination MAC address
    u_char src_addr[ETHER_ADDR_LEN];     // Source MAC address
    u_short ethertype;                    // Ethernet type
};

// Function to print MAC address in readable format
void print_mac_address(u_char* addr) {
    printf("%02x:%02x:%02x:%02x:%02x:%02x", 
           addr[0], addr[1], addr[2], 
           addr[3], addr[4], addr[5]);
}

// Callback function for packet capture
void packet_handler(u_char *args, const struct pcap_pkthdr *header, const u_char *packet) {
    struct ethernet_header *eth_hdr;

    eth_hdr = (struct ethernet_header*)(packet);
    printf("Captured a packet:\n");
  
    // Print source and destination MAC addresses
    printf("Destination MAC: ");
    print_mac_address(eth_hdr->dest_addr);
    printf("\n");

    printf("Source MAC: ");
    print_mac_address(eth_hdr->src_addr);
    printf("\n");

    printf("Packet length: %d bytes\n", header->len);
    printf("-------------------------------------------------\n");
}

int main(int argc, char *argv[]) {
    char *dev;                       // Network device
    char errbuf[PCAP_ERRBUF_SIZE];  // Error buffer
    pcap_t *handle;                 // Packet capture handle

    // Check for device argument
    if (argc < 2) {
        fprintf(stderr, "Usage: %s <device>\n", argv[0]);
        exit(EXIT_FAILURE);
    }

    dev = argv[1];

    // Open the device for packet capture
    handle = pcap_open_live(dev, BUFSIZ, 1, 1000, errbuf);
    if (handle == NULL) {
        fprintf(stderr, "Could not open device %s: %s\n", dev, errbuf);
        exit(EXIT_FAILURE);
    }

    printf("Starting packet capture on device %s...\n", dev);

    // Capture packets in an infinite loop
    pcap_loop(handle, 0, packet_handler, NULL);

    // Close the pcap handle
    pcap_close(handle);
    return 0;
}