//Falcon-180B DATASET v1.0 Category: Arithmetic ; Style: innovative
#include <stdio.h>
#include <stdlib.h>
#include <time.h>
#include <math.h>

// Function to generate a random number
double get_random_number(double min, double max) {
    return (double)rand() / RAND_MAX * (max - min) + min;
}

// Function to calculate the factorial of a number
int factorial(int n) {
    int result = 1;
    for (int i = 2; i <= n; i++) {
        result *= i;
    }
    return result;
}

// Function to calculate the Fibonacci sequence up to a given number of terms
void fibonacci(int n) {
    int a = 0, b = 1, c;
    printf("Fibonacci sequence up to %d terms:\n", n);
    printf("0 1 ");
    for (int i = 2; i < n; i++) {
        c = a + b;
        a = b;
        b = c;
        printf("%d ", c);
    }
}

// Function to calculate the sum of an arithmetic series
double arithmetic_series_sum(int n, double a, double d) {
    return (n / 2) * (2 * a + (n - 1) * d);
}

// Function to calculate the sum of a geometric series
double geometric_series_sum(int n, double a, double r) {
    return a * (1 - pow(r, n)) / (1 - r);
}

// Function to calculate the sum of a harmonic series
double harmonic_series_sum(int n) {
    double sum = 0;
    for (int i = 1; i <= n; i++) {
        sum += 1 / i;
    }
    return sum;
}

int main() {
    srand(time(NULL));

    // Example usage of get_random_number function
    printf("Random number between 1 and 100: %f\n", get_random_number(1, 100));

    // Example usage of factorial function
    printf("Factorial of 5: %d\n", factorial(5));

    // Example usage of fibonacci function
    fibonacci(10);

    // Example usage of arithmetic_series_sum function
    printf("Sum of the arithmetic series 1 + 2 + 3 +... + 10: %f\n", arithmetic_series_sum(10, 1, 1));

    // Example usage of geometric_series_sum function
    printf("Sum of the geometric series 2 + 4 + 8 +... + 1024: %f\n", geometric_series_sum(10, 2, 2));

    // Example usage of harmonic_series_sum function
    printf("Sum of the harmonic series 1 + 1/2 + 1/3 +... + 1/10: %f\n", harmonic_series_sum(10));

    return 0;
}