//MISTRAL-7B DATASET v1.0 Category: Cat Language Translator ; Style: funny
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <ctype.h>

// Function to check if a character is a valid CAT token
int is_cat_token(char c) {
    return (strchr("();{},+=!*%&^<>=!|?/:\\\"'`", c) != NULL);
}

// Function to translate CAT tokens to English
const char* cat_to_english[] = {
    "MEOW", "FISH", "SCRATCH", "BITE", " PURR ", "MEOW_LOUDLY",
    "SLEEP", "EAT", "JUMP", "SIT", "PLAY", "LOVE", "HATE",
    "MEOW_SOFTLY", "GIVE_FISH", "CHASE", "MEOW_QUICKLY",
    "LOOK", "FOLLOW", "MEOW_FRIENDLY", "MEOW_AGGRESSIVELY",
    "MIAOW", "PURR_LOUDLY", "RUB_AGAINST", "GROOM_SELF",
    "MEOW_SADLY", "SCREAMED", "RUN_AWAY", "HIDE", "SURPRISED",
    "CONFUSED", "GREETED", "WOULD_LIKE", "WOULD_NOT_LIKE",
    "SMILED", "CRYED", "LAUGHED", "YAWNED", "SLEPT_ON", "SAT_ON",
    "WATCHED", "FOLLOWED_WITH_EYES", "APPROACHED", "BACKED_AWAY",
    "MEOWED_QUIETLY", "MEOWED_ANGRILY", "MEOWED_EXCITEDLY", "MEOWED_CURIOUSLY"
};

// Function to translate a single CAT token to English
const char* translate_cat_token(char* token) {
    size_t len = strlen(token);
    for (size_t i = 0; i < sizeof(cat_to_english) / sizeof(cat_to_english[0]); i++) {
        if (len == strlen(cat_to_english[i])) {
            return cat_to_english[i];
        }
    }
    return "UNKNOWN_TOKEN";
}

// Function to translate a CAT program to English
void translate_cat_program(char* program) {
    char token[32];
    int i = 0;
    while (program[i] != '\0') {
        int j = 0;
        while (program[i] != ' ' && program[i] != '\t' && program[i] != '\n') {
            token[j++] = program[i++];
            token[j] = '\0';
            if (is_cat_token(token[0])) {
                const char* english = translate_cat_token(token);
                printf("%s: %s\n", english, token);
            }
        }
        i++;
    }
}

// Main function to read a CAT program from stdin and translate it to English
int main() {
    char program[1024];
    fgets(program, sizeof(program), stdin);
    translate_cat_program(program);
    return 0;
}

// Here are some example CAT programs for you to translate to English
// 1. A simple "Hello, World!" program
// MEOW SLEEP 5 SCREAMED "HELLO" FISH MEOW_LOUDLY MEOW_LOUDLY MEOW
// 2. A program that makes a cat chase its tail
// MEOW SLEEP 1 CHASE MEOW
// 3. A program that makes a cat play with a ball
// PLAY BALL PLAY BALL PLAY BALL GIVE_FISH MEOW_QUICKLY
// 4. A program that makes a cat sit and stay
// SIT SIT SIT LOOK AT ME SIT SIT