//Falcon-180B DATASET v1.0 Category: Internet Speed Test Application ; Style: calm
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <time.h>
#include <curl/curl.h>

#define INTERVAL_MS 1000
#define NUM_REQUESTS 10
#define BUFFER_SIZE 65536

size_t WriteCallback(void* contents, size_t size, size_t nmemb, void* userp) {
    size_t realsize = size * nmemb;
    char* buffer = (char*)malloc(realsize + 1);
    memcpy(buffer, contents, realsize);
    buffer[realsize] = '\0';
    printf("%s", buffer);
    free(buffer);
    return realsize;
}

int main() {
    CURL* curl;
    CURLcode res;
    char url[100];
    double total_time = 0.0;
    double speed = 0.0;

    curl_global_init(CURL_GLOBAL_DEFAULT);
    curl = curl_easy_init();

    if(curl) {
        for(int i = 0; i < NUM_REQUESTS; i++) {
            sprintf(url, "https://speedtest.net/speedtest.php?test=%d", i+1);

            curl_easy_setopt(curl, CURLOPT_URL, url);
            curl_easy_setopt(curl, CURLOPT_WRITEFUNCTION, WriteCallback);

            res = curl_easy_perform(curl);
            if(res!= CURLE_OK) {
                fprintf(stderr, "curl_easy_perform() failed: %s\n", curl_easy_strerror(res));
            }

            curl_easy_cleanup(curl);
        }

        curl_global_cleanup();
    }

    return 0;
}