//Falcon-180B DATASET v1.0 Category: Drone Remote Control ; Style: enthusiastic
#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <fcntl.h>
#include <termios.h>

#define BAUDRATE B9600
#define DEVICE "/dev/ttyUSB0"

int main() {
    int fd;
    struct termios options;

    // Open the serial port
    fd = open(DEVICE, O_RDWR | O_NOCTTY);

    if (fd < 0) {
        perror("Error opening serial port");
        exit(1);
    }

    // Get the current options for the port
    if (tcgetattr(fd, &options) < 0) {
        perror("Error getting options");
        exit(1);
    }

    // Set the baud rate
    cfsetispeed(&options, BAUDRATE);
    cfsetospeed(&options, BAUDRATE);

    // Set the options for the port
    tcsetattr(fd, TCSANOW, &options);

    // Send commands to the drone
    printf("Takeoff\n");
    write(fd, "Takeoff\n", 8);

    sleep(3);

    printf("Fly forward\n");
    write(fd, "Fly forward\n", 11);

    sleep(3);

    printf("Turn left\n");
    write(fd, "Turn left\n", 10);

    sleep(3);

    printf("Turn right\n");
    write(fd, "Turn right\n", 11);

    sleep(3);

    printf("Land\n");
    write(fd, "Land\n", 6);

    close(fd);
    return 0;
}