//Falcon-180B DATASET v1.0 Category: Terminal Based Game ; Style: surrealist
#include <stdio.h>
#include <stdlib.h>
#include <time.h>

#define BOARD_SIZE 10

typedef struct {
    char name[20];
    int health;
    int attack;
} Player;

void generateBoard() {
    int i, j;
    for (i = 0; i < BOARD_SIZE; i++) {
        for (j = 0; j < BOARD_SIZE; j++) {
            if (i % 2 == 0 && j % 2 == 0) {
                printf(".");
            } else if (i % 2 == 1 && j % 2 == 1) {
                printf("#");
            } else {
                printf(" ");
            }
        }
        printf("\n");
    }
}

void drawHealthBar(Player *player) {
    int healthPercentage = (player->health * 100) / player->attack;
    int healthBarLength = BOARD_SIZE - 2;
    int i;
    for (i = 0; i < healthBarLength; i++) {
        if (i < healthPercentage) {
            printf("#");
        } else {
            printf(".");
        }
    }
}

void drawPlayerInfo(Player *player1, Player *player2) {
    printf("\n");
    printf("Player 1: %s\n", player1->name);
    printf("Health: %d\n", player1->health);
    printf("Attack: %d\n", player1->attack);
    drawHealthBar(player1);
    printf("\n");
    printf("Player 2: %s\n", player2->name);
    printf("Health: %d\n", player2->health);
    printf("Attack: %d\n", player2->attack);
    drawHealthBar(player2);
    printf("\n");
}

int main() {
    srand(time(NULL));
    Player player1, player2;
    strcpy(player1.name, "Player 1");
    player1.health = rand() % 100 + 1;
    player1.attack = rand() % 100 + 1;
    strcpy(player2.name, "Player 2");
    player2.health = rand() % 100 + 1;
    player2.attack = rand() % 100 + 1;
    int i;
    for (i = 0; i < 3; i++) {
        int attackResult = rand() % 101;
        if (attackResult <= player1.attack) {
            player2.health -= player1.attack;
        } else {
            player1.health -= player2.attack;
        }
        drawPlayerInfo(&player1, &player2);
        usleep(100000);
    }
    return 0;
}