//GEMINI-pro DATASET v1.0 Category: Bucket Sort Implementation ; Style: all-encompassing
#include <stdio.h>
#include <stdlib.h>

#define BUCKET_SIZE 5
#define MAX_VALUE 100

// Function to sort the array using bucket sort
void bucketSort(int arr[], int n)
{
    // Create n empty buckets
    int buckets[n][BUCKET_SIZE];

    // Initialize all buckets to empty
    for (int i = 0; i < n; i++)
    {
        for (int j = 0; j < BUCKET_SIZE; j++)
        {
            buckets[i][j] = 0;
        }
    }

    // Distribute the elements into the buckets
    for (int i = 0; i < n; i++)
    {
        int bucketIndex = arr[i] / BUCKET_SIZE;
        int bucketPosition = arr[i] % BUCKET_SIZE;

        buckets[bucketIndex][bucketPosition]++;
    }

    // Sort the elements in each bucket
    for (int i = 0; i < n; i++)
    {
        int bucketIndex = arr[i] / BUCKET_SIZE;
        int bucketPosition = arr[i] % BUCKET_SIZE;

        for (int j = 0; j < BUCKET_SIZE; j++)
        {
            if (buckets[bucketIndex][j] > 0)
            {
                arr[i] = bucketIndex * BUCKET_SIZE + j;
                buckets[bucketIndex][j]--;
                break;
            }
        }
    }
}

// Function to print the array
void printArray(int arr[], int n)
{
    for (int i = 0; i < n; i++)
    {
        printf("%d ", arr[i]);
    }
    printf("\n");
}

// Driver code to test the bucket sort
int main()
{
    int arr[] = {2, 5, 3, 1, 4, 8, 6, 7, 9, 10};
    int n = sizeof(arr) / sizeof(arr[0]);

    bucketSort(arr, n);

    printf("Sorted array: ");
    printArray(arr, n);

    return 0;
}