//GPT-4o-mini DATASET v1.0 Category: Syntax parsing ; Style: calm
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <ctype.h>

#define MAX_TOKENS 100
#define MAX_TOKEN_LENGTH 50

typedef enum {
    TOKEN_IDENTIFIER,
    TOKEN_NUMBER,
    TOKEN_OPERATOR,
    TOKEN_SEMICOLON,
    TOKEN_UNKNOWN,
    TOKEN_EOF
} TokenType;

typedef struct {
    TokenType type;
    char value[MAX_TOKEN_LENGTH];
} Token;

void skipWhitespace(const char **input) {
    while (isspace(**input)) {
        (*input)++;
    }
}

Token nextToken(const char **input) {
    Token token = {TOKEN_UNKNOWN, ""};

    skipWhitespace(input);

    if (**input == '\0') {
        token.type = TOKEN_EOF;
        return token;
    }

    if (isalpha(**input) || **input == '_') {
        int len = 0;
        while (isalnum(**input) || **input == '_') {
            if (len < MAX_TOKEN_LENGTH - 1) {
                token.value[len++] = **input;
            }
            (*input)++;
        }
        token.value[len] = '\0';
        token.type = TOKEN_IDENTIFIER;
    } else if (isdigit(**input)) {
        int len = 0;
        while (isdigit(**input)) {
            if (len < MAX_TOKEN_LENGTH - 1) {
                token.value[len++] = **input;
            }
            (*input)++;
        }
        token.value[len] = '\0';
        token.type = TOKEN_NUMBER;
    } else if (**input == '+' || **input == '-' || **input == '*' || **input == '/') {
        token.type = TOKEN_OPERATOR;
        token.value[0] = **input;
        token.value[1] = '\0';
        (*input)++;
    } else if (**input == ';') {
        token.type = TOKEN_SEMICOLON;
        token.value[0] = **input;
        token.value[1] = '\0';
        (*input)++;
    } else {
        token.value[0] = **input;
        token.value[1] = '\0';
        (*input)++;
    }

    return token;
}

void parse(const char *input) {
    const char *current = input;
    Token token;

    while ((token = nextToken(&current)).type != TOKEN_EOF) {
        switch (token.type) {
            case TOKEN_IDENTIFIER:
                printf("Identifier: %s\n", token.value);
                break;
            case TOKEN_NUMBER:
                printf("Number: %s\n", token.value);
                break;
            case TOKEN_OPERATOR:
                printf("Operator: %s\n", token.value);
                break;
            case TOKEN_SEMICOLON:
                printf("Semicolon: %s\n", token.value);
                break;
            case TOKEN_UNKNOWN:
                printf("Unknown: %s\n", token.value);
                break;
            default:
                break;
        }
    }
}

int main() {
    const char *input = "int main() { int a = 5; a = a + 2; return a; }";
    printf("Parsing input: \"%s\"\n\n", input);
    parse(input);
    return 0;
}