//Code Llama-13B DATASET v1.0 Category: Building a SMTP Client ; Style: light-weight
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <arpa/inet.h>
#include <unistd.h>

#define PORT 25
#define BUFSIZE 1024
#define EMAIL_MAX_SIZE 1024

typedef struct {
    char *recipient;
    char *subject;
    char *message;
} email_t;

int send_email(email_t *email) {
    int sockfd, n;
    char buf[BUFSIZE];
    struct sockaddr_in server_addr;

    if ((sockfd = socket(AF_INET, SOCK_STREAM, 0)) == -1) {
        perror("socket");
        return -1;
    }

    server_addr.sin_family = AF_INET;
    server_addr.sin_port = htons(PORT);
    server_addr.sin_addr.s_addr = inet_addr("127.0.0.1");

    if (connect(sockfd, (struct sockaddr *)&server_addr, sizeof(server_addr)) == -1) {
        perror("connect");
        return -1;
    }

    n = send(sockfd, email->recipient, strlen(email->recipient), 0);
    if (n == -1) {
        perror("send");
        return -1;
    }

    n = send(sockfd, email->subject, strlen(email->subject), 0);
    if (n == -1) {
        perror("send");
        return -1;
    }

    n = send(sockfd, email->message, strlen(email->message), 0);
    if (n == -1) {
        perror("send");
        return -1;
    }

    close(sockfd);
    return 0;
}

int main() {
    email_t email;
    email.recipient = "john.doe@example.com";
    email.subject = "Test Email";
    email.message = "This is a test email";

    send_email(&email);

    return 0;
}