//Falcon-180B DATASET v1.0 Category: Network Topology Mapper ; Style: immersive
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#define MAX_NODES 100
#define MAX_EDGES 1000

typedef struct {
    int id;
    char name[50];
} Node;

typedef struct {
    int src;
    int dest;
    int weight;
} Edge;

Node nodes[MAX_NODES];
Edge edges[MAX_EDGES];

int num_nodes = 0;
int num_edges = 0;

void add_node(int id, char* name) {
    num_nodes++;
    nodes[num_nodes-1].id = id;
    strcpy(nodes[num_nodes-1].name, name);
}

void add_edge(int src, int dest, int weight) {
    num_edges++;
    edges[num_edges-1].src = src;
    edges[num_edges-1].dest = dest;
    edges[num_edges-1].weight = weight;
}

int main() {
    // Add nodes
    add_node(1, "Node 1");
    add_node(2, "Node 2");
    add_node(3, "Node 3");
    add_node(4, "Node 4");
    add_node(5, "Node 5");

    // Add edges
    add_edge(1, 2, 5);
    add_edge(2, 3, 2);
    add_edge(3, 1, 3);
    add_edge(3, 4, 4);
    add_edge(4, 5, 1);

    // Print nodes and edges
    printf("Nodes:\n");
    for (int i = 0; i < num_nodes; i++) {
        printf("%d - %s\n", nodes[i].id, nodes[i].name);
    }

    printf("\nEdges:\n");
    for (int i = 0; i < num_edges; i++) {
        printf("%d -> %d (%d)\n", edges[i].src, edges[i].dest, edges[i].weight);
    }

    return 0;
}