//GEMINI-pro DATASET v1.0 Category: Greedy Algorithms ; Style: dynamic
#include <stdio.h>
#include <stdlib.h>

// Structure to represent a job
typedef struct Job {
    int id;         // Job ID
    int deadline;   // Deadline of the job
    int profit;     // Profit associated with the job
} Job;

// Function to compare jobs based on their deadlines
int compareJobs(const void *a, const void *b) {
    Job *job1 = (Job *)a;
    Job *job2 = (Job *)b;
    return job1->deadline - job2->deadline;
}

// Function to find the maximum profit by scheduling jobs
int findMaxProfit(Job jobs[], int n) {
    // Sort jobs in increasing order of their deadlines
    qsort(jobs, n, sizeof(Job), compareJobs);

    // Create an array to store the scheduled jobs
    int schedule[n];
    for (int i = 0; i < n; i++) {
        schedule[i] = -1;
    }

    // Initialize the current time to 1
    int currentTime = 1;

    // Iterate over the jobs in order of their deadlines
    for (int i = 0; i < n; i++) {
        // Find the first available slot in the schedule
        int j;
        for (j = jobs[i].deadline - 1; j >= 0; j--) {
            if (schedule[j] == -1) {
                break;
            }
        }

        // If a slot is available, schedule the job
        if (j >= 0) {
            schedule[j] = jobs[i].id;
            currentTime++;
        }
    }

    // Calculate the total profit
    int totalProfit = 0;
    for (int i = 0; i < n; i++) {
        if (schedule[i] != -1) {
            totalProfit += jobs[i].profit;
        }
    }

    return totalProfit;
}

// Main function to test the program
int main() {
    // Create an array of jobs
    Job jobs[] = {
        {1, 2, 100},
        {2, 1, 19},
        {3, 2, 27},
        {4, 1, 25},
        {5, 3, 15},
    };

    int n = sizeof(jobs) / sizeof(jobs[0]);

    // Find the maximum profit by scheduling jobs
    int maxProfit = findMaxProfit(jobs, n);

    // Print the maximum profit
    printf("Maximum profit: %d\n", maxProfit);

    return 0;
}