//Falcon-180B DATASET v1.0 Category: Threading Library Implementation ; Style: intelligent
#include <stdio.h>
#include <stdlib.h>
#include <pthread.h>

// Define the number of threads
#define NUM_THREADS 5

// Define the stack size for each thread
#define STACK_SIZE 1024

// Define the mutex
pthread_mutex_t mutex = PTHREAD_MUTEX_INITIALIZER;

// Define the shared variable
int shared_var = 0;

// Define the thread function
void* thread_func(void* arg) {
    int id = *(int*) arg;
    printf("Thread %d is running\n", id);
    pthread_mutex_lock(&mutex);
    shared_var++;
    printf("Thread %d incremented the shared variable to %d\n", id, shared_var);
    pthread_mutex_unlock(&mutex);
    return NULL;
}

// Define the main function
int main() {
    pthread_t threads[NUM_THREADS];
    int ids[NUM_THREADS];

    // Initialize the thread IDs
    for (int i = 0; i < NUM_THREADS; i++) {
        ids[i] = i;
    }

    // Create the threads
    for (int i = 0; i < NUM_THREADS; i++) {
        pthread_create(&threads[i], NULL, thread_func, &ids[i]);
    }

    // Wait for the threads to finish
    for (int i = 0; i < NUM_THREADS; i++) {
        pthread_join(threads[i], NULL);
    }

    printf("The final value of the shared variable is %d\n", shared_var);

    return 0;
}