//Falcon-180B DATASET v1.0 Category: Network Topology Mapper ; Style: beginner-friendly
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#define MAX_NODES 100
#define MAX_EDGES 200

typedef struct {
    int id;
    char name[50];
    int degree;
} Node;

typedef struct {
    int u;
    int v;
    int weight;
} Edge;

Node nodes[MAX_NODES];
Edge edges[MAX_EDGES];
int num_nodes = 0;
int num_edges = 0;

void add_node(int id, char* name) {
    num_nodes++;
    nodes[num_nodes-1].id = id;
    strcpy(nodes[num_nodes-1].name, name);
    nodes[num_nodes-1].degree = 0;
}

void add_edge(int u, int v, int weight) {
    num_edges++;
    edges[num_edges-1].u = u;
    edges[num_edges-1].v = v;
    edges[num_edges-1].weight = weight;
    nodes[u-1].degree++;
    nodes[v-1].degree++;
}

void print_nodes() {
    printf("Nodes:\n");
    for (int i = 0; i < num_nodes; i++) {
        printf("%d: %s (%d neighbors)\n", nodes[i].id, nodes[i].name, nodes[i].degree);
    }
}

void print_edges() {
    printf("\nEdges:\n");
    for (int i = 0; i < num_edges; i++) {
        printf("%d -> %d (%d)\n", edges[i].u, edges[i].v, edges[i].weight);
    }
}

int main() {
    add_node(1, "Node 1");
    add_node(2, "Node 2");
    add_node(3, "Node 3");
    add_node(4, "Node 4");
    add_node(5, "Node 5");

    add_edge(1, 2, 10);
    add_edge(2, 3, 20);
    add_edge(3, 4, 30);
    add_edge(4, 5, 40);

    print_nodes();
    print_edges();

    return 0;
}