//GPT-4o-mini DATASET v1.0 Category: Public-Key Algorithm Implementation ; Style: Ken Thompson
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <math.h>

// Function to calculate greatest common divisor
int gcd(int a, int b) {
    return (b == 0) ? a : gcd(b, a % b);
}

// Function to perform modular exponentiation
long long mod_exp(long long base, long long exp, long long mod) {
    long long result = 1;
    base = base % mod;
    while (exp > 0) {
        if (exp % 2 == 1) {
            result = (result * base) % mod;
        }
        exp = exp >> 1;
        base = (base * base) % mod;
    }
    return result;
}

// Function to generate the keys
void generate_keys(int *public_key, int *private_key, int *n) {
    int p = 61; // Example prime number
    int q = 53; // Example prime number
    *n = p * q; // n = p * q
    int phi = (p - 1) * (q - 1); // Euler's Totient Function

    *public_key = 17; // Example public exponent

    // Ensure the public key is relatively prime to phi
    while (gcd(*public_key, phi) != 1) {
        (*public_key)++;
    }

    // Calculate private key using the extended Euclidean algorithm
    for (int k = 1; k < 100; k++) {
        if ((1 + k * phi) % *public_key == 0) {
            *private_key = (1 + k * phi) / *public_key;
            break;
        }
    }
}

// Function to encrypt the message
long long encrypt(int public_key, int n, long long message) {
    return mod_exp(message, public_key, n);
}

// Function to decrypt the message
long long decrypt(int private_key, int n, long long ciphertext) {
    return mod_exp(ciphertext, private_key, n);
}

int main() {
    int public_key, private_key, n;
    generate_keys(&public_key, &private_key, &n);

    printf("Public Key: %d\n", public_key);
    printf("Private Key: %d\n", private_key);
    printf("n: %d\n\n", n);

    long long message = 42; // Original message
    printf("Original Message: %lld\n", message);

    // Encrypt the message
    long long encrypted_message = encrypt(public_key, n, message);
    printf("Encrypted Message: %lld\n", encrypted_message);

    // Decrypt the message
    long long decrypted_message = decrypt(private_key, n, encrypted_message);
    printf("Decrypted Message: %lld\n", decrypted_message);

    if (message == decrypted_message) {
        printf("Success! The decrypted message matches the original.\n");
    } else {
        printf("Something went wrong! Decrypted message does not match.\n");
    }

    return 0;
}