//GEMINI-pro DATASET v1.0 Category: Packet Capturer with pcap library ; Style: single-threaded
#include <pcap.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>

#define SNAP_LEN 1518
#define PROMISC 1
#define TIMEOUT 1000

void packet_handler(u_char *user, const struct pcap_pkthdr *h, const u_char *bytes) {
  printf("Packet length: %d\n", h->len);
  printf("Number of bytes captured: %d\n", h->caplen);
  printf("Received packet at %s\n", ctime((const time_t *)&h->ts.tv_sec));
  printf("Payload:\n");
  for (int i = 0; i < h->caplen; i++) {
    printf("%02x ", bytes[i]);
    if ((i + 1) % 16 == 0) printf("\n");
  }
  printf("\n\n");
}

int main() {
  char errbuf[PCAP_ERRBUF_SIZE];
  pcap_t *handle;
  struct bpf_program fp;
  char filter_exp[] = "tcp and port 80";
  bpf_u_int32 netmask = 0xFFFFFF;

  // Open the network interface
  handle = pcap_open_live("eth0", SNAP_LEN, PROMISC, TIMEOUT, errbuf);
  if (handle == NULL) {
    fprintf(stderr, "Error opening the network interface: %s\n", errbuf);
    exit(1);
  }

  // Compile the filter expression
  if (pcap_compile(handle, &fp, filter_exp, 0, netmask) == -1) {
    fprintf(stderr, "Error compiling the filter expression: %s\n", pcap_geterr(handle));
    exit(1);
  }

  // Set the filter
  if (pcap_setfilter(handle, &fp) == -1) {
    fprintf(stderr, "Error setting the filter: %s\n", pcap_geterr(handle));
    exit(1);
  }

  // Start capturing packets
  pcap_loop(handle, -1, packet_handler, NULL);

  // Close the network interface
  pcap_close(handle);

  return 0;
}