//Gemma-7B DATASET v1.0 Category: Haunted House Simulator ; Style: happy
#include <stdio.h>
#include <stdlib.h>
#include <time.h>

#define MAX_GHOULS 5

typedef struct Ghost {
  char name[20];
  int room;
  int health;
  int action;
} Ghost;

Ghost ghouls[MAX_GHOULS] = {
  {"Mortimer", 1, 100, 0},
  {"Barnabus", 2, 80, 1},
  {"Samantha", 3, 60, 2},
  {"Theodosia", 4, 40, 3},
  {"Ezekiel", 5, 20, 4}
};

void haunt_house() {
  int i, j, rand_room, rand_action;
  time_t t;

  // Randomly choose a room for each ghost to haunt
  for (i = 0; i < MAX_GHOULS; i++) {
    ghouls[i].room = rand() % 5 + 1;
  }

  // Create a random time delay
  t = time(NULL);
  sleep(rand() % 5 + 1);

  // Have each ghost perform its action
  for (i = 0; i < MAX_GHOULS; i++) {
    switch (ghouls[i].action) {
      case 0:
        printf("Ghost %s has wandered into room %d.\n", ghouls[i].name, ghouls[i].room);
        break;
      case 1:
        printf("Ghost %s has moved to room %d.\n", ghouls[i].name, ghouls[i].room);
        break;
      case 2:
        printf("Ghost %s has attacked the player.\n", ghouls[i].name);
        break;
    }
  }
}

int main() {
  haunt_house();

  return 0;
}