//Gemma-7B DATASET v1.0 Category: Stock market tracker ; Style: post-apocalyptic
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <time.h>

#define MAX_STOCK_NUM 10

typedef struct Stock {
  char name[20];
  double current_price;
  double previous_price;
  double change;
} Stock;

Stock stocks[MAX_STOCK_NUM] = {
  {"Tesla", 1200.0, 1180.0, 20.0},
  {"Apple", 1300.0, 1280.0, 20.0},
  {"Amazon", 1400.0, 1360.0, 40.0},
  {"Microsoft", 1500.0, 1480.0, 20.0},
  {"Intel", 1600.0, 1560.0, 40.0},
  {"Oracle", 1700.0, 1680.0, 20.0},
  {"IBM", 1800.0, 1760.0, 40.0},
  {"Johnson & Johnson", 1900.0, 1880.0, 20.0},
  {"Boeing", 2000.0, 1960.0, 40.0},
  {"Ford", 2100.0, 2060.0, 40.0}
};

void update_stock_prices() {
  for (int i = 0; i < MAX_STOCK_NUM; i++) {
    stocks[i].previous_price = stocks[i].current_price;
    stocks[i].current_price = rand() % 100 + 1000.0;
    stocks[i].change = stocks[i].current_price - stocks[i].previous_price;
  }
}

void print_stock_summary() {
  printf("--------------------------------------------------------\n");
  printf("  Stock Market Tracker - Post-Apocalyptic Edition\n");
  printf("--------------------------------------------------------\n");
  printf("  Name\t\tCurrent Price\t\tPrevious Price\t\tChange\n");
  printf("--------------------------------------------------------\n");
  for (int i = 0; i < MAX_STOCK_NUM; i++) {
    printf("%s\t\t%.2f\t\t%.2f\t\t%.2f\n", stocks[i].name, stocks[i].current_price, stocks[i].previous_price, stocks[i].change);
  }
  printf("--------------------------------------------------------\n");
}

int main() {
  update_stock_prices();
  print_stock_summary();

  return 0;
}