//GEMINI-pro DATASET v1.0 Category: Electronic Voting System ; Style: standalone
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

// Define the maximum number of candidates and voters
#define MAX_CANDIDATES 10
#define MAX_VOTERS 100

// Define the structure of a candidate
typedef struct {
  char name[50];
  int votes;
} Candidate;

// Define the structure of a voter
typedef struct {
  int id;
  int voted;
} Voter;

// Define the array of candidates
Candidate candidates[MAX_CANDIDATES];

// Define the array of voters
Voter voters[MAX_VOTERS];

// Define the number of candidates
int num_candidates = 0;

// Define the number of voters
int num_voters = 0;

// Define the current voter
int current_voter = 0;

// Function to add a candidate
void add_candidate(char *name) {
  strcpy(candidates[num_candidates].name, name);
  candidates[num_candidates].votes = 0;
  num_candidates++;
}

// Function to add a voter
void add_voter(int id) {
  voters[num_voters].id = id;
  voters[num_voters].voted = 0;
  num_voters++;
}

// Function to vote for a candidate
void vote(int candidate_id) {
  if (voters[current_voter].voted == 0) {
    candidates[candidate_id].votes++;
    voters[current_voter].voted = 1;
  }
}

// Function to print the results of the election
void print_results() {
  printf("Election Results:\n");
  for (int i = 0; i < num_candidates; i++) {
    printf("%s: %d votes\n", candidates[i].name, candidates[i].votes);
  }
}

// Main function
int main() {
  // Add candidates
  add_candidate("John Smith");
  add_candidate("Jane Doe");

  // Add voters
  add_voter(1);
  add_voter(2);

  // Vote
  vote(0);
  vote(1);

  // Print results
  print_results();

  return 0;
}