//GPT-4o-mini DATASET v1.0 Category: Robot movement control ; Style: curious
#include <stdio.h>
#include <unistd.h>
#include <stdlib.h>
#include <string.h>
#include <time.h>

#define MAX_MOVEMENTS 10
#define GRID_SIZE 5

typedef struct {
    int x;
    int y;
} Position;

typedef enum {
    MOVE_UP,
    MOVE_DOWN,
    MOVE_LEFT,
    MOVE_RIGHT,
    STAY
} Movement;

void printGrid(Position *robot) {
    printf("\nCurrent Position of the robot (X):\n");
    for (int i = 0; i < GRID_SIZE; i++) {
        for (int j = 0; j < GRID_SIZE; j++) {
            if (i == robot->y && j == robot->x) {
                printf("[R] ");
            } else {
                printf("[ ] ");
            }
        }
        printf("\n");
    }
}

Movement getRandomMovement() {
    return rand() % 5; // Returns a value from 0 to 4
}

void executeMovement(Position *robot, Movement move) {
    switch (move) {
        case MOVE_UP:
            if (robot->y > 0) {
                robot->y--;
            }
            break;
        case MOVE_DOWN:
            if (robot->y < GRID_SIZE - 1) {
                robot->y++;
            }
            break;
        case MOVE_LEFT:
            if (robot->x > 0) {
                robot->x--;
            }
            break;
        case MOVE_RIGHT:
            if (robot->x < GRID_SIZE - 1) {
                robot->x++;
            }
            break;
        case STAY:
            // Do nothing
            break;
    }
}

int main() {
    srand(time(0)); // Seed the random number generator

    Position robot = {0, 0}; // Start position of the robot at top-left corner
    Movement movements[MAX_MOVEMENTS];

    printf("Welcome to the Curious Robot Movement Control Simulator!\n");
    
    for (int i = 0; i < MAX_MOVEMENTS; i++) {
        movements[i] = getRandomMovement(); // Generate random movements
    }

    for (int i = 0; i < MAX_MOVEMENTS; i++) {
        printGrid(&robot); // Display the grid and robot's position
        
        switch (movements[i]) {
            case MOVE_UP:
                printf("Robot is moving UP.\n");
                break;
            case MOVE_DOWN:
                printf("Robot is moving DOWN.\n");
                break;
            case MOVE_LEFT:
                printf("Robot is moving LEFT.\n");
                break;
            case MOVE_RIGHT:
                printf("Robot is moving RIGHT.\n");
                break;
            case STAY:
                printf("Robot is staying still.\n");
                break;
        }

        executeMovement(&robot, movements[i]); // Move the robot according to the generated command

        // Simulate delay for observing movement
        sleep(1);
    }

    printf("The robot has completed its movements! Final position is (%d, %d).\n", robot.x, robot.y);
    printGrid(&robot); // Final state of the grid

    return 0;
}