//Falcon-180B DATASET v1.0 Category: Building a HTTP Client ; Style: Dennis Ritchie
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <ctype.h>
#include <curl/curl.h>

// Callback function for writing data to a file
size_t WriteCallback(void* contents, size_t size, size_t nmemb, FILE* userp) {
    return fwrite(contents, size, nmemb, userp);
}

// Function for parsing headers
size_t HeaderCallback(char* buffer, size_t size, size_t nmemb, void* userp) {
    FILE* file = (FILE*)userp;
    fwrite(buffer, size, nmemb, file);
    return size * nmemb;
}

int main(int argc, char* argv[]) {
    if (argc!= 4) {
        printf("Usage: %s <method> <url> <output_file>\n", argv[0]);
        return 1;
    }

    CURL* curl = curl_easy_init();
    if (!curl) {
        printf("Error initializing curl\n");
        return 1;
    }

    char* method = argv[1];
    char* url = argv[2];
    FILE* output_file = fopen(argv[3], "w");
    if (!output_file) {
        printf("Error opening output file\n");
        fclose(output_file);
        curl_easy_cleanup(curl);
        return 1;
    }

    struct curl_slist* headers = NULL;
    headers = curl_slist_append(headers, "Accept: */*");
    headers = curl_slist_append(headers, "Content-Type: application/json");

    curl_easy_setopt(curl, CURLOPT_URL, url);
    curl_easy_setopt(curl, CURLOPT_CUSTOMREQUEST, method);
    curl_easy_setopt(curl, CURLOPT_HTTPHEADER, headers);
    curl_easy_setopt(curl, CURLOPT_WRITEFUNCTION, WriteCallback);
    curl_easy_setopt(curl, CURLOPT_WRITEDATA, output_file);
    curl_easy_setopt(curl, CURLOPT_HEADERFUNCTION, HeaderCallback);
    curl_easy_setopt(curl, CURLOPT_HEADERDATA, output_file);

    CURLcode res = curl_easy_perform(curl);
    if (res!= CURLE_OK) {
        printf("Error performing request: %s\n", curl_easy_strerror(res));
        fclose(output_file);
        curl_easy_cleanup(curl);
        return 1;
    }

    fclose(output_file);
    curl_easy_cleanup(curl);
    return 0;
}