//GEMINI-pro DATASET v1.0 Category: Matrix operations ; Style: Dennis Ritchie
#include <stdio.h>
#include <stdlib.h>

/*
 * Matrix operations example program.
 *
 * This program demonstrates the basic operations of matrix addition, subtraction,
 * multiplication, and transposition.
 */

/*
 * Define the size of the matrices.
 */
#define N 3

/*
 * Define the data type of the matrices.
 */
typedef int matrix[N][N];

/*
 * Print a matrix.
 */
void print_matrix(const matrix a) {
    for (int i = 0; i < N; i++) {
        for (int j = 0; j < N; j++) {
            printf("%d ", a[i][j]);
        }
        printf("\n");
    }
}

/*
 * Add two matrices.
 */
void add_matrices(const matrix a, const matrix b, matrix c) {
    for (int i = 0; i < N; i++) {
        for (int j = 0; j < N; j++) {
            c[i][j] = a[i][j] + b[i][j];
        }
    }
}

/*
 * Subtract two matrices.
 */
void subtract_matrices(const matrix a, const matrix b, matrix c) {
    for (int i = 0; i < N; i++) {
        for (int j = 0; j < N; j++) {
            c[i][j] = a[i][j] - b[i][j];
        }
    }
}

/*
 * Multiply two matrices.
 */
void multiply_matrices(const matrix a, const matrix b, matrix c) {
    for (int i = 0; i < N; i++) {
        for (int j = 0; j < N; j++) {
            c[i][j] = 0;
            for (int k = 0; k < N; k++) {
                c[i][j] += a[i][k] * b[k][j];
            }
        }
    }
}

/*
 * Transpose a matrix.
 */
void transpose_matrix(const matrix a, matrix b) {
    for (int i = 0; i < N; i++) {
        for (int j = 0; j < N; j++) {
            b[i][j] = a[j][i];
        }
    }
}

/*
 * Main function.
 */
int main() {
    // Create three matrices.
    matrix a = {{1, 2, 3}, {4, 5, 6}, {7, 8, 9}};
    matrix b = {{10, 11, 12}, {13, 14, 15}, {16, 17, 18}};
    matrix c;

    // Print the original matrices.
    printf("Matrix A:\n");
    print_matrix(a);
    printf("\nMatrix B:\n");
    print_matrix(b);

    // Add the two matrices.
    add_matrices(a, b, c);

    // Print the result of the addition.
    printf("\nMatrix A + Matrix B:\n");
    print_matrix(c);

    // Subtract the two matrices.
    subtract_matrices(a, b, c);

    // Print the result of the subtraction.
    printf("\nMatrix A - Matrix B:\n");
    print_matrix(c);

    // Multiply the two matrices.
    multiply_matrices(a, b, c);

    // Print the result of the multiplication.
    printf("\nMatrix A * Matrix B:\n");
    print_matrix(c);

    // Transpose the first matrix.
    transpose_matrix(a, c);

    // Print the result of the transposition.
    printf("\nTranspose of Matrix A:\n");
    print_matrix(c);

    return 0;
}